<?php

class ImageResize
{
  public $ratio = 1;
  public $max_width;
  public $max_height;

  // Zmiana wielkoci obrazka
  public function process($gd_img)
  {
    // Ustalamy wymiary pocztkowe
    $old_width  = imagesx($gd_img);
    $old_height = imagesy($gd_img);
    $new_width  = 0;
    $new_height = 0;

    // Nowe wymiary musz zmieci si w podanych maksymalnych wymiarach
    if ($this->max_width and $this->max_height)
    {
      if ($this->max_width/$old_width <= $this->max_height/$old_height)
      {
        $new_width =  ceil(($this->max_width/$old_width) * $old_width);
        $new_height = ceil(($this->max_width/$old_width) * $old_height);
      }
      else
      {
        $new_width  = ceil(($this->max_height/$old_height) * $old_width);
        $new_height = ceil(($this->max_height/$old_height) * $old_height);
      } 
    }
    // Nowe wymiary wyliczane na podstawie wspczynnika
    else if ($this->ratio)
    {
      $new_width  = ceil($this->ratio * $old_width);
      $new_height = ceil($this->ratio * $old_height);
    }

    // Robimy cokolwiek tylko wtedy, gdy rzeczywicie zmieniaj si wymiary obrazka
    if ($new_width and $new_height)
    {
      // Tworzymy obrazek docelowy
      $temp = imagecreatetruecolor($new_width, $new_height);

      // Ustalamy parametry kanau alfa
      imagesavealpha($temp, true);
      imagealphablending($temp, false);

      // Zmieniamy wielko obrazka
      imagecopyresampled($temp, 
                         $gd_img, 
                         0, 
                         0, 
                         0, 
                         0, 
                         $new_width, 
                         $new_height, 
                         $old_width, 
                         $old_height);
      $gd_img = $temp;
    }

    return $gd_img;
  }
}

?>
